/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.cim.provider.pi.PIIOConDataTable;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.FSPCMRespHdlr;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt64;
import org.snia.wbem.client.ProviderCIMOMHandle;

public class PIIOConHandler
implements FSPCMRespHdlr {
    private int counter;
    private Hashtable dataTable;
    private String m_cecName;
    private UnsignedInt16 m_eventID;
    private static final String HYP_PIPE_CANCEL_REQUEST = "HYP_PIPE_CANCEL_REQUEST";
    public static final UnsignedInt16 EXCHANGE_CAPS_EVENT_ID = new UnsignedInt16(1025);
    public static final UnsignedInt16 CAN_VARY_OFF_EVENT_ID = new UnsignedInt16(1041);
    public static final UnsignedInt16 VARY_OFF_EVENT_ID = new UnsignedInt16(1042);
    public static final UnsignedInt16 VARY_ON_EVENT_ID = new UnsignedInt16(1043);

    public PIIOConHandler(Vector vector, Vector vector2, String string, UnsignedInt16 unsignedInt16, ProviderCIMOMHandle providerCIMOMHandle) {
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "PIIOConHandler constructor ->");
        }
        System.out.println("In the constructor of PIIOConHandler");
        this.m_cecName = string;
        System.out.println("The cec name in PIIOConHandler :" + string);
        this.m_eventID = unsignedInt16;
        System.out.println("Event ID: " + this.m_eventID);
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "CEC name in PIIOConHandler :" + string);
            Trace.trace("apcmhscF", "Event ID: " + this.m_eventID);
        }
        this.counter = vector.size();
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "Counter is set to :" + this.counter);
        }
        System.out.println("The counter is set to :" + this.counter);
        this.dataTable = new Hashtable(this.counter);
        this.updateTable(vector, vector2, string, unsignedInt16, providerCIMOMHandle);
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "<- PIIOConHandler constructor");
        }
    }

    private void updateTable(Vector vector, Vector vector2, String string, UnsignedInt16 unsignedInt16, ProviderCIMOMHandle providerCIMOMHandle) {
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "PIIOConHandler.updateTable ->");
        }
        System.out.println("Building the Hashtable table");
        System.out.println("The cecName is:" + string);
        for (int i = 0; i < this.counter; ++i) {
            PIIOConDataTable pIIOConDataTable = new PIIOConDataTable((Integer)vector2.elementAt(i), string, unsignedInt16, providerCIMOMHandle);
            if (3 <= Trace.LEVEL) {
                Trace.trace("apcmhscD", "Request ID in the hashtable is :" + vector.elementAt(i));
            }
            System.out.println("The request ID in the Hash table is :" + vector.elementAt(i));
            this.dataTable.put((Integer)vector.elementAt(i), pIIOConDataTable);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "<- PIIOConHandler.updateTable");
        }
    }

    public int processResp(Hashtable hashtable, int n) {
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "PIIOConHandler.processResp ->");
        }
        System.out.println(" Processing the Async response ======== In processResp");
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "The request ID is : " + n);
        }
        System.out.println("The request ID is : " + n);
        if (!this.dataTable.containsKey(new Integer(n))) {
            if (2 <= Trace.LEVEL) {
                Trace.trace("apcmhscF", "Request ID not in the handler table!!");
            }
            System.out.println("Request ID not in the handler table");
            if (2 <= Trace.LEVEL) {
                Trace.trace("apcmhscF", "<- PIIOConHandler.processResp");
            }
            return 2;
        }
        PIIOConDataTable pIIOConDataTable = (PIIOConDataTable)this.dataTable.get(new Integer(n));
        --this.counter;
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "Processing data & adding to the table");
        }
        System.out.println("Processing data & adding to the table ==== processResp");
        pIIOConDataTable.updateRow(hashtable);
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "<- PIIOConHandler.processResp");
        }
        if (this.counter == 0) {
            System.out.println("++++COUNTER IS AT 0!!!++++");
            return 1;
        }
        return 0;
    }

    public int processAck(Hashtable hashtable, int n) {
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "PIIOConHandler.processAck ->");
        }
        int n2 = 0;
        System.out.println("In processAck in PIIOConHandler class");
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "The request ID is : " + n);
            Trace.trace("apcmhscF", "The hashtable is :" + this.dataTable);
        }
        System.out.println("The request ID is : " + n);
        System.out.println("The hashtable is :" + this.dataTable);
        if (!this.dataTable.containsKey(new Integer(n))) {
            if (2 <= Trace.LEVEL) {
                Trace.trace("apcmhscF", "Request ID not in the handler table" + n);
            }
            System.out.println("Request ID not in the handler table" + n);
            if (2 <= Trace.LEVEL) {
                Trace.trace("apcmhscF", "<- PIIOConHandler.processAck");
            }
            return 2;
        }
        PIIOConDataTable pIIOConDataTable = (PIIOConDataTable)this.dataTable.get(new Integer(n));
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "<- PIIOConHandler.processAck");
        }
        n2 = pIIOConDataTable.ackProcessing(hashtable);
        return n2;
    }

    public Hashtable processTable(int[] nArray) {
        Object object;
        Vector<Integer> vector = new Vector<Integer>();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector<UnsignedInt64> vector5 = new Vector<UnsignedInt64>();
        Hashtable hashtable = new Hashtable();
        OmCecMgr omCecMgr = OmCecMgr.getCecMgr(this.m_cecName);
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "PIIOConHandler.processTable ->");
        }
        System.out.println("In Process Table Method");
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "m_eventID: " + this.m_eventID);
        }
        System.out.println("m_eventID: " + this.m_eventID);
        if (nArray != null && nArray.length != 0) {
            if (2 <= Trace.LEVEL) {
                Trace.trace("apcmhscF", "There are some partitions we did not get asynch responses for!");
            }
            System.out.println("There are some partitions we did not get asynch responses for!");
            for (int i = 0; i < nArray.length; ++i) {
                System.out.println("The not processed id in processTable is :" + nArray[i]);
                if (!this.dataTable.containsKey(new Integer(nArray[i]))) continue;
                System.out.println("The Hashtable contains the keys");
                object = (PIIOConDataTable)this.dataTable.get(new Integer(nArray[i]));
                System.out.println("The ConDataTable is :" + object);
                try {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace("apcmhscF", "Canceling hyp pipe request...");
                    }
                    System.out.println("Canceling hyp pipe request...");
                    Hashtable hashtable2 = fspCmdHelper.cancelHypPipeRequest(nArray[i]);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                    throwable.printStackTrace();
                }
                System.out.println("Updating the conDataTable with timed out value");
                ((PIIOConDataTable)object).updateCancelRequest();
            }
        }
        UnsignedInt64 unsignedInt64 = new UnsignedInt64("0");
        object = this.dataTable.elements();
        while (object.hasMoreElements()) {
            boolean bl;
            int n;
            System.out.println("The FOR loop i processTable");
            PIIOConDataTable pIIOConDataTable = (PIIOConDataTable)object.nextElement();
            int n2 = pIIOConDataTable.getPartId();
            Vector vector6 = pIIOConDataTable.getreturnCodeVec();
            Vector vector7 = pIIOConDataTable.getreturnLenVec();
            Vector vector8 = pIIOConDataTable.getreturnCodeDataVec();
            if (this.m_eventID.equals((Object)EXCHANGE_CAPS_EVENT_ID)) {
                System.out.println("Exchange caps event - get Lpar capability");
                unsignedInt64 = pIIOConDataTable.getLparCap();
                if (2 <= Trace.LEVEL) {
                    Trace.trace("apcmhscF", "Exchange caps event - LPAR capability: " + unsignedInt64);
                }
            }
            System.out.println("The return code Vector size is :" + vector6.size());
            System.out.println("The return Length Vector size is :" + vector7.size());
            System.out.println("The return code data Vector size is :" + vector8.size());
            System.out.println("lpar capability: " + unsignedInt64);
            for (n = 0; n < vector6.size(); ++n) {
                vector.addElement(new Integer(n2));
            }
            if (vector6.size() > 0) {
                bl = vector2.addAll(vector6);
            }
            if (vector7.size() > 0) {
                bl = vector3.addAll(vector7);
            }
            if (vector8.size() > 0) {
                bl = vector4.addAll(vector8);
            }
            if (!this.m_eventID.equals((Object)EXCHANGE_CAPS_EVENT_ID)) continue;
            System.out.println("retCode.size(): " + vector6.size());
            System.out.println("Adding element to returnLparCapVec");
            for (n = 0; n < vector6.size(); ++n) {
                vector5.addElement(unsignedInt64);
                System.out.println("returnLparCapVec size: " + vector5.size());
            }
        }
        hashtable.put("PARTITION_ID", vector);
        hashtable.put("RETURN_CODE", vector2);
        hashtable.put("RETURN_CODE_LEN", vector3);
        hashtable.put("RETURN_CODE_DATA", vector4);
        if (this.m_eventID.equals((Object)EXCHANGE_CAPS_EVENT_ID)) {
            if (3 <= Trace.LEVEL) {
                Trace.trace("apcmhscD", "Exchange caps - putting capability vector into hashtable");
            }
            System.out.println("putting capability vector into hashtable");
            hashtable.put("PART_CAPABILITY", vector5);
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace("apcmhscF", "<- PIIOConHandler.processTable");
        }
        return hashtable;
    }
}

